Ext.data.JsonP.sol_common_as_renderer_Excel({"tagname":"class","name":"sol.common.as.renderer.Excel","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.as.renderer.Excel.js","href":"lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel"}],"author":[{"tagname":"author","name":"ELO Digital Office GmbH","email":null}],"version":["1.1"],"eloas":true,"requires":["sol.common.DateUtils","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.StringUtils","sol.common.Template","sol.common.as.ExcelDocument"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"copyMetaData","tagname":"cfg","owner":"sol.common.as.renderer.Excel","id":"cfg-copyMetaData","meta":{}},{"name":"datasheet","tagname":"cfg","owner":"sol.common.as.renderer.Excel","id":"cfg-datasheet","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.as.renderer.Excel","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.as.renderer.Excel","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"targetId","tagname":"cfg","owner":"sol.common.as.renderer.Excel","id":"cfg-targetId","meta":{}},{"name":"templateId","tagname":"cfg","owner":"sol.common.as.renderer.Excel","id":"cfg-templateId","meta":{"required":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mapPrefix","tagname":"property","owner":"sol.common.as.renderer.Excel","id":"property-mapPrefix","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"copyObject","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-copyObject","meta":{"private":true}},{"name":"expandRowSord","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-expandRowSord","meta":{"private":true}},{"name":"fillExcelSpreadsheet","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-fillExcelSpreadsheet","meta":{"private":true}},{"name":"getIndexFromName","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-getIndexFromName","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-initialize","meta":{"private":true}},{"name":"isDate","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-isDate","meta":{"private":true}},{"name":"isNumber","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-isNumber","meta":{"private":true}},{"name":"prepareColumnMapping","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-prepareColumnMapping","meta":{"private":true}},{"name":"prepareHeader","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-prepareHeader","meta":{"private":true}},{"name":"readHeader","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-readHeader","meta":{"private":true}},{"name":"readHeaderFromSord","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-readHeaderFromSord","meta":{"private":true}},{"name":"readHeaderFromWorksheet","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-readHeaderFromWorksheet","meta":{"private":true}},{"name":"render","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-render","meta":{}},{"name":"renderExcel","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-renderExcel","meta":{"private":true}},{"name":"writeData","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-writeData","meta":{"private":true}},{"name":"writeLine","tagname":"method","owner":"sol.common.as.renderer.Excel","id":"method-writeLine","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.as.renderer.Excel","short_doc":"Rendering Excel file from a Excel template. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.as.renderer.Excel</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'>sol.common.as.ExcelDocument</div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel' target='_blank'>lib_sol.common.as.renderer.Excel.js</a></div></pre><div class='doc-contents'><p>Rendering Excel file from a Excel template.</p>\n\n<p>This can either be used for creating a new Document in the archive (<code>targetId</code> specified) or can create a new version on an existing object (<code>objId</code>).</p>\n\n<p>Which fields will be written, is specified by the template (first line of the data worksheet contains the ObjKeys)\nor by the first Sord of the data.sords array (all ObjKeys).</p>\n      <p class='version-tag'>Version: <b>1.1</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-templateId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-cfg-templateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-cfg-templateId' class='name expandable'>templateId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>The template which should be rendered</p>\n</div><div class='long'><p>The template which should be rendered</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-copyMetaData' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-cfg-copyMetaData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-cfg-copyMetaData' class='name expandable'>copyMetaData</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>If <code>true</code>, the mask and the metadata of the template will be copied to the new document</p>\n</div><div class='long'><p>If <code>true</code>, the mask and the metadata of the template will be copied to the new document</p>\n</div></div></div><div id='cfg-datasheet' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-cfg-datasheet' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-cfg-datasheet' class='name expandable'>datasheet</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Specifies on which worksheet the data should be written ...</div><div class='long'><p>Specifies on which worksheet the data should be written</p>\n<p>Defaults to: <code>&quot;Data&quot;</code></p></div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>The rendered document will be saved as a version of this object\nEither <code>targetId</code> or <code>objId</code> has to be defined.</p>\n</div><div class='long'><p>The rendered document will be saved as a version of this object\nEither <code>targetId</code> or <code>objId</code> has to be defined.</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;templateId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-targetId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-cfg-targetId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-cfg-targetId' class='name expandable'>targetId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>The target folder to store the rendered document</p>\n</div><div class='long'><p>The target folder to store the rendered document</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mapPrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-property-mapPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-property-mapPrefix' class='name expandable'>mapPrefix</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;MAP_&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-copyObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-copyObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-copyObject' class='name expandable'>copyObject</a>( <span class='pre'>rowSord</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rowSord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Row sord</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-expandRowSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-expandRowSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-expandRowSord' class='name expandable'>expandRowSord</a>( <span class='pre'>rowSord</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Extract the lines for the map items. ...</div><div class='long'><p>Extract the lines for the map items.\nIf there is a map value with an index, the line (the ObjKeys) will be repeated for each map index.\nIf the <code>rowSord</code> contains <code>mapKeys</code>, those will be used and the map values will not be checked out again.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rowSord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Row sord</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-fillExcelSpreadsheet' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-fillExcelSpreadsheet' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-fillExcelSpreadsheet' class='name expandable'>fillExcelSpreadsheet</a>( <span class='pre'>excelDocument, data</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Fills the data to an Excel spreadsheet ...</div><div class='long'><p>Fills the data to an Excel spreadsheet</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>excelDocument</span> : sol.common.as.ExcelDocument<div class='sub-desc'><p>Excel document</p>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>Data   *</p>\n</div></li></ul></div></div></div><div id='method-getIndexFromName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-getIndexFromName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-getIndexFromName' class='name expandable'>getIndexFromName</a>( <span class='pre'>fieldName</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-isDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-isDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-isDate' class='name expandable'>isDate</a>( <span class='pre'>cell</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if a Cell is formated as date. ...</div><div class='long'><p>Checks, if a Cell is formated as date.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cell</span> : com.aspose.cells.Cell<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-isNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-isNumber' class='name expandable'>isNumber</a>( <span class='pre'>cell</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if a Cell is formated as number. ...</div><div class='long'><p>Checks, if a Cell is formated as number.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cell</span> : com.aspose.cells.Cell<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-prepareColumnMapping' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-prepareColumnMapping' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-prepareColumnMapping' class='name expandable'>prepareColumnMapping</a>( <span class='pre'>sord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord</p>\n</div></li></ul></div></div></div><div id='method-prepareHeader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-prepareHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-prepareHeader' class='name expandable'>prepareHeader</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-readHeader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-readHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-readHeader' class='name expandable'>readHeader</a>( <span class='pre'>sord</span> ) : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-readHeaderFromSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-readHeaderFromSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-readHeaderFromSord' class='name expandable'>readHeaderFromSord</a>( <span class='pre'>sord</span> ) : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-readHeaderFromWorksheet' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-readHeaderFromWorksheet' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-readHeaderFromWorksheet' class='name expandable'>readHeaderFromWorksheet</a>( <span class='pre'></span> ) : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-render' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-render' class='name expandable'>render</a>( <span class='pre'>name, data</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts the template rendering. ...</div><div class='long'><p>Starts the template rendering.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>Name</p>\n</div></li><li><span class='pre'>data</span> : String<div class='sub-desc'><p>Data</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-renderExcel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-renderExcel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-renderExcel' class='name expandable'>renderExcel</a>( <span class='pre'>data, config</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>Data</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-writeData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-writeData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-writeData' class='name expandable'>writeData</a>( <span class='pre'>rowSords</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rowSords</span> : de.elo.ix.client.Sord[]<div class='sub-desc'><p>Row Sords</p>\n</div></li></ul></div></div></div><div id='method-writeLine' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Excel'>sol.common.as.renderer.Excel</span><br/><a href='source/lib_sol.common.as.renderer.Excel.html#sol-common-as-renderer-Excel-method-writeLine' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Excel-method-writeLine' class='name expandable'>writeLine</a>( <span class='pre'>rowIndex, rowData</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rowIndex</span> : Number<div class='sub-desc'><p>Row index</p>\n</div></li><li><span class='pre'>rowData</span> : Array<div class='sub-desc'><p>Row data</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true}});